<?php

namespace Omnipay\Stripe\Message;

use Omnipay\Tests\TestCase;

class FetchCustomerRequestTest extends TestCase {

    public function setUp() {
        $this->request = new FetchCustomerRequest($this->getHttpClient(), $this->getHttpRequest());
        $this->request->setCustomerReference('cus_1MZSEtqSghKx99');
    }

    public function testEndpoint() {
        $this->assertSame('https://api.stripe.com/v1/customers/cus_1MZSEtqSghKx99', $this->request->getEndpoint());
    }

    public function testHttpMethod() {
        $this->assertSame('GET', $this->request->getHttpMethod());
    }

    public function testSendSuccess() {
        $this->setMockHttpResponse('FetchCustomerSuccess.txt');
        $response = $this->request->send();
        $this->assertTrue($response->isSuccessful());
        $this->assertFalse($response->isRedirect());
        $this->assertNull($response->getTransactionReference());
        $this->assertSame('cus_1MZSEtqSghKx99', $response->getCustomerReference());
        $this->assertNull($response->getMessage());
    }

    public function testSendFailure() {
        $this->setMockHttpResponse('FetchCustomerFailure.txt');
        $response = $this->request->send();
        $this->assertFalse($response->isSuccessful());
        $this->assertFalse($response->isRedirect());
        $this->assertNull($response->getTransactionReference());
        $this->assertNull($response->getCustomerReference());
        $this->assertSame('No such customer: cus_1MZSEtqSghKx99', $response->getMessage());
    }

}
